/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-08-08
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef POISSONCONDITION_H
#define POISSONCONDITION_H

#include <DinverCore.h>
#include <QGpCoreWave.h>
#include "GroundParameter.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

struct ParamProfile;
class ProfileLimits;

class DINVERDCCORE_EXPORT PoissonCondition : public AbstractCondition
{
public:
  PoissonCondition(ParamProfile * vp, ParamProfile * vs, ParamProfile * nu);

  virtual bool operator==( const AbstractCondition& o ) const;

  virtual const QString& xml_tagName() const { return xmlPoissonConditionTag;}
  static const QString xmlPoissonConditionTag;

  virtual void getLimits( int paramIndex, double& min, double& max) const;
  virtual void humanInfo() const;
  bool isOk(const GroundParameter * from);
protected:
  virtual uint internalChecksum() const;
private:
  inline const GroundParameter& parameter( int index ) const;
  void getTopLimits( const ProfileLimits& pl, double& min, double& max ) const;
  void getBottomLimits( const ProfileLimits& pl, double& min, double& max ) const;
  void getDepthLimits( const ProfileLimits& pl, double& min, double& max ) const;

  ParamProfile * _vp;
  ParamProfile * _vs;
  ParamProfile * _nu;

  Profile _min, _max;
};

inline const GroundParameter& PoissonCondition::parameter( int index ) const
{
  return static_cast<const GroundParameter&>(AbstractCondition::parameter(index));
}

} // namespace DinverDCCore

#endif // POISSONCONDITION_H
