/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TARGET_H
#define TARGET_H

#include <QGpCoreTools.h>
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT Target : public XMLClass
{
public:
  Target();
  Target(const Target& o);

  bool selected() const {return _selected;}
  void setSelected(bool s) {_selected= s;}

  double misfitWeight() const {return _misfitWeight;}
  void setMisfitWeight(double w) {_misfitWeight= w;}

  double minimumMisfit() const {return _minimumMisfit; }
  void setMinimumMisfit(double m) {_minimumMisfit=m;}

  StatValue::MisfitType misfitType() const {return _misfitType;}
  void setMisfitType(StatValue::MisfitType t) {_misfitType=t;}
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  bool _selected;
  double _misfitWeight;
  double _minimumMisfit;
  StatValue::MisfitType _misfitType;
};

} // namespace DinverDCCore

#endif // TARGET_H
