/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-07-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VALUETARGET_H
#define VALUETARGET_H

#include "Target.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class DINVERDCCORE_EXPORT ValueTarget : public Target
{
public:
  ValueTarget();
  ValueTarget(const ValueTarget& o);

  virtual const QString& xml_tagName() const {return xmlValueTargetTag;}
  static const QString xmlValueTargetTag;

  const StatValue& value() const {return _value;}
  StatValue& value() {return _value;}
  void setValue(const StatValue& v) {_value=v;}
protected:
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
private:
  StatValue _value;
};

} // namespace DinverDCCore

#endif // VALUETARGET_H
