/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-05-18
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DCMODELVIEWER_H
#define DCMODELVIEWER_H

#include <DinverCore.h>
#include <DinverDCCore.h>
#include <QGpCoreTools.h>
#include <SciFigs.h>

#include "DinverDCGuiDLLExport.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT DCModelViewer : public QWidget
{
  Q_OBJECT
public:
  DCModelViewer(QWidget * parent=0);
  ~DCModelViewer();

  void initGraphs(int nGraphs);
  virtual void setMode( const Mode& ) {}
  virtual void setModeIndex( int ) {}
  virtual void setFrequencyAxis( bool ) {}
  virtual void setTarget( TargetList * tl );
  void selectModels(QString reportFileName, double maxMisfit);
  void selectModels(DCModelViewer * w, const QVector<int> * indexes);
  void rejectModels(DCModelViewer * w, const QVector<int> * indexes);
  void loadModels();
  int modelCount() const { return _models.count(); }

  GraphicSheet * sheet() { return &_sheet; }
public slots:
  void setLimits();
  void showSelectedModels( int id, const QVector<int>* indexes );
protected slots:
  virtual void showTarget(bool isVisible);
protected:
  QMenu * addMenu( QString title );
  TextEdit * addText( int ig, QString text );
  virtual AbstractLine * targetReferenceLine() const = 0;

  GraphicSheet _sheet;
  ColorPaletteWidget * _palette;
  QVBoxLayout* _childLayout;
#ifndef Q_WS_MAC
  QMenuBar * _menuBar;
#endif

  QList<DCModelInfo *> _models;

  int _nGraphs;
  AxisWindow ** _graphs;
  XYValueLines ** _curveLayers;
  LineLayer ** _targetLayers;
  int ** _pCounts;
  double * _misfits;

  void addActions();
  virtual void setTitles( int i )=0;
  virtual bool hasCurves(DCReportBlock& dcBlock) = 0;
  virtual void setSampleCount( DCModelInfo * info, DCReportBlock& dcBlock)=0;
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info)=0;
  virtual void setLimits(int i, const Rect& r)=0;
  virtual void setGlobalLimits(const Rect&) {}
};

} // namespace DinverDCGui

#endif // DCMODELVIEWER_H
