/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-01-18
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONVIEWER_H
#define DISPERSIONVIEWER_H

#include <QGpCoreWave.h>
#include "DCModelViewer.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT DispersionViewer : public DCModelViewer
{
  Q_OBJECT
public:
  DispersionViewer(QWidget * parent=0);
  ~DispersionViewer();

  virtual void setMode( const Mode& m );
protected:
  virtual void setTitles( int i );
  virtual bool hasCurves(DCReportBlock& dcBlock);
  virtual void setSampleCount( DCModelInfo * info, DCReportBlock& dcBlock);
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info);
  virtual void setLimits(int i, const Rect& r);
  virtual void setTarget( TargetList * tl );
  virtual AbstractLine * targetReferenceLine() const;

  bool seekMode( DCReportBlock& dcBlock );
  Mode _mode;
};

} // namespace DinverDCGui

#endif // DISPERSIONVIEWER_H
