/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-05-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPTICITYVIEWER_H
#define ELLIPTICITYVIEWER_H

#include <SciFigs.h>

#include "DispersionViewer.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT EllipticityViewer : public DCModelViewer
{
  Q_OBJECT
public:
  EllipticityViewer(QWidget * parent=0);
  ~EllipticityViewer();
protected:
  virtual void setTitles( int i );
  virtual bool hasCurves(DCReportBlock& dcBlock);
  virtual void setSampleCount( DCModelInfo * info, DCReportBlock& dcBlock);
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info);
  virtual void setLimits(int i, const Rect& r);
  virtual DCModelViewer * newInstance() {return new EllipticityViewer;}
  virtual void setTarget( TargetList * tl );
  virtual void showTarget(bool isVisible);
  virtual AbstractLine * targetReferenceLine() const;
private:
  ParallelBands ** _peakTargetLayers;
};

} // namespace DinverDCGui

#endif // ELLIPTICITYVIEWER_H
