/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-12-22
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GROUNDMODELVIEWER_H
#define GROUNDMODELVIEWER_H

#include "DCModelViewer.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT GroundModelViewer : public DCModelViewer
{
  Q_OBJECT
public:
  GroundModelViewer(QWidget * parent=0);
  ~GroundModelViewer();
public slots:
  void exportModels();
  void saveAsReport();
  void minMaxProfiles();
protected:
  virtual void setTitles( int i );
  virtual bool hasCurves(DCReportBlock&) { return true; }
  virtual void setSampleCount( DCModelInfo * info, DCReportBlock& dcBlock);
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info);
  virtual void setLimits(int i, const Rect& r);
  virtual void setGlobalLimits(const Rect&);
  virtual AbstractLine * targetReferenceLine() const;
};

} // namespace DinverDCGui

#endif // GROUNDMODELVIEWER_H
