/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-21
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONVIEWER_H
#define REFRACTIONVIEWER_H

#include "DinverDCGuiDLLExport.h"
#include "DCModelViewer.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT RefractionViewer : public DCModelViewer
{
public:
  RefractionViewer(QWidget * parent=0);
protected:
  virtual void setTitles( int i );
  virtual void setSampleCount( DCModelInfo * info, DCReportBlock& dcBlock);
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info);
  virtual void setLimits(int i, const Rect& r);
  virtual AbstractLine * targetReferenceLine() const;

  QVector<double> _sources;
};

class DINVERDCGUI_EXPORT RefractionVpViewer : public RefractionViewer
{
public:
  RefractionVpViewer(QWidget * parent=0);
  ~RefractionVpViewer();
protected:
  virtual bool hasCurves(DCReportBlock& dcBlock);
  virtual void setTarget( TargetList * tl );
};

class DINVERDCGUI_EXPORT RefractionVsViewer : public RefractionViewer
{
public:
  RefractionVsViewer(QWidget * parent=0);
  ~RefractionVsViewer();
protected:
  virtual bool hasCurves(DCReportBlock& dcBlock);
  virtual void setTarget( TargetList * tl );
};

} // namespace DinverDCGui

#endif // REFRACTIONVIEWER_H
