/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-05-19
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VIEWERPARAM_H
#define VIEWERPARAM_H

#include <QGpCoreWave.h>
#include <QGpGuiTools.h>
#include "ui_ViewerParam.h"
#include "DinverDCGuiDLLExport.h"

namespace DinverDCGui {

class DCModelViewer;

class DINVERDCGUI_EXPORT ViewerParam : public Dialog, protected Ui::ViewerParam
{
  Q_OBJECT
public:
  ViewerParam(QWidget * parent=0);

  DCModelViewer * groundProfile(QStringList reportFileNames) { return setViewer(0, reportFileNames); }
  DCModelViewer * dispersion(QStringList reportFileNames) { return setViewer(1, reportFileNames); }
  DCModelViewer * autocorr(QStringList reportFileNames) { return setViewer(2, reportFileNames); }
  DCModelViewer * ellipticity(QStringList reportFileNames) { return setViewer(3, reportFileNames); }
  DCModelViewer * refractionVp(QStringList reportFileNames) { return setViewer(4, reportFileNames); }
  DCModelViewer * refractionVs(QStringList reportFileNames) { return setViewer(5, reportFileNames); }
  void select( DCModelViewer * w, const QVector<int> * indexes );
  void reject( DCModelViewer * w, const QVector<int> * indexes );
private slots:
  void on_viewer_currentIndexChanged( int index );
private:
  DCModelViewer * setViewer( int index, QStringList reportFileNames );

  void setModeEnabled( bool e );
  void setModeSlownessEnabled( bool e );
  void setModeIndexEnabled( bool e );
  void setAxisEnabled( bool e );

  void setModePolarisationRL();
  void setModePolarisationVRT();

  void removeMaxMisfit();
  void removeMode();
  void removeModeSlowness();
  void removeModeIndex();
  void removeAxis();

  bool exec();
  Mode mode() const;
  DCModelViewer * createViewer( int index );
};

} // namespace DinverDCGui

#endif // VIEWERPARAM_H
