/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-14
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALFORMAT_H
#define ASCIISIGNALFORMAT_H

#include "AsciiSignalFormatRule.h"
#include "AsciiSignalFormatComponent.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT AsciiSignalFormat : public XMLClass, public SharedObject
{
  TRANSLATIONS("AsciiSignalFormat")
public:
  AsciiSignalFormat();
  AsciiSignalFormat(const AsciiSignalFormat& o);

  virtual const QString& xml_tagName() const {return xmlAsciiSignalFormatTag;}
  static const QString xmlAsciiSignalFormatTag;

  void setName(const QString& n) {_name=n;}
  const QString& name() const {return _name;}
  QString toString() const;

  void setExtension(const QString& e) {_extension=e;}
  const QString& extension() const {return _extension;}

  bool isValidExtension(const QString );
  bool isValid();

  enum HeaderType {NoHeader, FixedHeader, HeaderPattern, EndHeaderPattern};

  void setHeaderType(HeaderType t) {_headerType=t;}
  void setHeaderType(const QString& t);
  HeaderType headerType() const {return _headerType;}
  QString headerTypeString() const;

  const QString& headerPattern() const { return _headerPattern; }
  void setHeaderPattern(const QString& h) { _headerPattern = h; }

  int headerLineCount() const { return _headerLineCount; }
  void setHeaderLineCount( int h ) { _headerLineCount = h; }

  const QString& timeFormat() const { return _timeFormat; }
  void setTimeFormat(const QString& t) { _timeFormat = t; }

  void insertComponent(int index, const AsciiSignalFormatComponent& c) {_components.insert(index, c);}
  void removeComponent(int index) {_components.remove(index);}
  int componentCount() const {return _components.count();}
  const AsciiSignalFormatComponent& component(int index) const {return _components.at(index);}
  AsciiSignalFormatComponent& component(int index) {return _components[index];}

  void insertRule(int index, const AsciiSignalFormatRule& r) {_rules.insert(index, r);}
  void removeRule(int index) {_rules.remove(index);}
  int ruleCount() const {return _rules.count();}
  int mandatoryRuleCount() const;
  const AsciiSignalFormatRule& rule(int index) const {return _rules.at(index);}
  AsciiSignalFormatRule& rule(int index) {return _rules[index];}

  QString header(QTextStream& s, int& lineNumber, QAtomicInt * terminate=0);
  bool parseHeader(const QString& headerText, QAtomicInt * terminate=0);
  double t0() const;
  QDateTime timeReference() const;
  void assign(Signal * sig);
protected:
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
private:
  QString _name, _extension;

  HeaderType _headerType;
  QString _headerPattern;
  int _headerLineCount;

  QString _timeFormat;
  QVector<AsciiSignalFormatComponent> _components;
  QVector<AsciiSignalFormatRule> _rules;
};

} // namespace GeopsyCore

#endif // ASCIISIGNALFORMAT_H
