/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-14
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALFORMATRULE_H
#define ASCIISIGNALFORMATRULE_H

#include <QGpCoreTools.h>

#include "Signal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT AsciiSignalFormatRule : public XMLClass
{
public:
  AsciiSignalFormatRule();
  AsciiSignalFormatRule(const AsciiSignalFormatRule& o);

  virtual const QString& xml_tagName() const {return xmlRuleTag;}
  static const QString xmlRuleTag;

  int channel() const { return _channel; }
  void setChannel( int c ) { _channel = c; }

  const Signal::DataIndex& data() const {return _data;}
  void setData(const Signal::DataIndex& d) {_data=d;}

  bool constant() const {return _constant;}
  void setConstant(bool c) {_constant=c;}

  bool mandatory() const {return _mandatory;}
  void setMandatory(bool m) {_mandatory=m;}

  int patternIndex() const { return _patternIndex; }
  void setPatternIndex(int i) {if(_patternIndex<0x40000000) _patternIndex=i;}

  QString pattern() const { return _pattern; }
  void setPattern( QString p ) { _pattern = p; }

  QVariant value() const { return _value; }
  void setValue( QVariant v ) { _value = v; }

  double factor() const { return _factor; }
  void setFactor( double f ) { _factor = f; }
protected:
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
private:
  int _channel;
  unsigned int _patternIndex:30;
  unsigned int _constant:1;
  unsigned int _mandatory:1;
  Signal::DataIndex _data;
  QString _pattern;
  QVariant _value;
  double _factor;
};

} // namespace GeopsyCore

#endif // ASCIISIGNALFORMATRULE_H
