/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-07-09
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CITYSCANNER_H
#define CITYSCANNER_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class CitySignal;

class GEOPSYCORE_EXPORT CityScanner: public Thread
{
  Q_OBJECT
public:
  CityScanner( QObject * parent = 0 );
  ~CityScanner();

  bool setPath( const QDir& cardPath );
  void cleanStop();
  void clear();
  int count() {return _signals.count();}
  void erase();
  const char * softwareVersion() const {return _softwareVersion;}
  const CitySignal * at(int index) const {return _signals.at(index);}
  QFile * readStream() { return fichbaseStream( _cardPath, QIODevice::ReadOnly ); }
signals:
  void signalsChanged();
protected:
  virtual void run();
  void normalScan();
  QFile * fichbaseStream(const QDir& cardPath, QIODevice::OpenModeFlag mode);
  QFile * sectcityStream(const QDir& cardPath, QIODevice::OpenModeFlag mode);
private:
  QDir _cardPath;
  QFile * _stream;
  QList<CitySignal *> _signals;
  char _softwareVersion[5];
  QAtomicInt _stopRequest;
};

} // namespace GeopsyCore

#endif // CITYSCANNER_H
