/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-06-15
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXSIGNAL_H
#define COMPLEXSIGNAL_H

#include <QGpCoreTools.h>
#include "SignalTemplate.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class DoubleSignal;

class GEOPSYCORE_EXPORT ComplexSignal : public SignalTemplate<Complex>
{
public:
  ComplexSignal( ) : SignalTemplate<Complex>() {}
  ComplexSignal( int n ) : SignalTemplate<Complex>(n) {}
  ComplexSignal( const ComplexSignal& o ) : SignalTemplate<Complex>(o) {}

  bool square();
  bool sqrt();
  bool multiply( double d );
  DoubleSignal * abs() const;
  DoubleSignal * toDouble() const;
  void debugPrint() const;
};

} // namespace GeopsyCore

#endif // COMPLEXSIGNAL_H
