/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2010-03-20
**  Authors :
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CUSTOMASCIIFORMATS_H
#define CUSTOMASCIIFORMATS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "SignalFileFormat.h"

namespace GeopsyCore {

class AsciiSignalFormat;

class GEOPSYCORE_EXPORT CustomAsciiFormats : public XMLClass
{
public:
  CustomAsciiFormats();
  ~CustomAsciiFormats();

  void setFormats(const CustomAsciiFormats& o);

  virtual const QString& xml_tagName() const {return xmlCustomAsciiFormatsTag;}
  static const QString xmlCustomAsciiFormatsTag;

  void save();

  int count() const {return _formats.count();}
  QString name(int index) const;

  SignalFileFormat fromExtension(const QString& ext) const;
  SignalFileFormat fromContent(const QString& fileName) const;
  SignalFileFormat fromString(const QString& f) const;
  QList<SignalFileFormat> list() const;
protected:
  void clear();
  void add(AsciiSignalFormat * format);
  void remove(int index);
  AsciiSignalFormat * format(int index) {return _formats.at(index);}

  virtual void xml_writeChildren( XML_WRITECHILDREN_ARGS ) const;
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
private:
  QList<AsciiSignalFormat *> _formats;
};

} // namespace GeopsyCore

#endif // CUSTOMASCIIFORMATS_H
