/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-04-09
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GP_DFFTPACK_H
#define GP_DFFTPACK_H

#include "FastFourierTransform.h"

namespace GeopsyCore {

#ifndef NO_FFT

// libDFFTPack interface

// Simplest interface: wsave must be a vector of 2*n+15 elements
extern "C" void dffti_( long * n, double * wsave );
extern "C" void dfftf_( long * n, double * r, double * wsave );
extern "C" void dfftb_( long * n, double * r, double * wsave );

// Lower level interface, where const and non const parts of wsave can be separated
// ch and wa have n elements, ifa has 15 elements
extern "C" void rffti1_( long * n, const double * wa, const double * ifac );
extern "C" void rfftf1_( long * n, double * r, double * ch, const double * wa, const double * ifac );
extern "C" void rfftb1_( long * n, double * r, double * ch, const double * wa, const double * ifac );

// Simplest interface: wsave must be a vector of 4*n+15 elements
extern "C" void zffti_( long * n, double * wsave );
extern "C" void zfftf_( long * n, QGpCoreTools::Complex * c, double * wsave );
extern "C" void zfftb_( long * n, QGpCoreTools::Complex * c, double * wsave );

// Lower level interface, where const and non const parts of wsave can be separated
// ch and wa have 2*n elements, ifa has 15 elements
extern "C" void cffti1_( long * n, const double * wa, const double * ifac );
extern "C" void cfftf1_( long * n, QGpCoreTools::Complex * r, double * ch, const double * wa, const double * ifac );
extern "C" void cfftb1_( long * n, QGpCoreTools::Complex * r, double * ch, const double * wa, const double * ifac );

class DFFTPack : public FastFourierTransform
{
public:
  virtual void forward( int nSamples, double * samples );
  virtual void backward( int nSamples, double * samples );

  virtual void forward( int nSamples, Complex * samples );
  virtual void backward( int nSamples, Complex * samples );

  virtual void manyForward( int howmany, int nSamples, Complex * samples );
  virtual void manyBackward( int howmany, int nSamples, Complex * samples );
};

#endif // NO_FFT

} // namespace GeopsyCore

#endif // DFFTPACK_H
