/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-04-30
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DYNAMICSIGNAL_H
#define DYNAMICSIGNAL_H

#include "Signal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT DynamicSignal : public Signal
{
  TRANSLATIONS("DynamicSignal")
public:
  DynamicSignal( SignalDB * db ) : Signal( db ) { _maxNSamples = 0; _t0Shift = 0; }
  ~DynamicSignal();

  void shiftT0( int nSamples );

  void set( double t, const int * samples, int nSamples );
  void set( double t, const double * samples, int nSamples );
  virtual int dataSize() const {return _maxNSamples * sizeof( double );}
  virtual void setNSamples(int n);
private:
  virtual bool allocate();
  virtual void free();
  template <class sampleType> inline void set( double t, const sampleType * samples, int nSamples );
private:
  int _maxNSamples;
  int _t0Shift;
};

} // namespace GeopsyCore

#endif // DYNAMICSIGNAL_H
