/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-04-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FASTFOURIERTRANSFORM_H
#define FASTFOURIERTRANSFORM_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT FastFourierTransform
{
public:
  FastFourierTransform();
  virtual ~FastFourierTransform() {}

  virtual void forward( int nSamples, double * samples ) = 0;
  virtual void backward( int nSamples, double * samples ) = 0;

  virtual void forward( int nSamples, Complex * samples ) = 0;
  virtual void backward( int nSamples, Complex * samples ) = 0;

  virtual void manyForward( int howmany, int nSamples, Complex * samples ) = 0;
  virtual void manyBackward( int howmany, int nSamples, Complex * samples ) = 0;

  static FastFourierTransform * instance() { return _self; }
private:
  static FastFourierTransform * _self;
};

} // namespace GeopsyCore

#endif // FASTFOURIERTRANSFORM_H
