/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-05-15
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FILTERPARAMETERS_H
#define FILTERPARAMETERS_H

#include <QtCore>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT FilterParameters
{
public:
  FilterParameters();

  enum Band { LowPass, HighPass, BandPass, BandReject };
  enum Method { Butterworth, CosineTaper };

  double fmin() const { return _fmin; }
  void setFmin( double f ) { _fmin = f; }

  double fmax() const { return _fmax; }
  void setFmax( double f ) { _fmax = f; }

  void sort();

  Band band() const { return _band; }
  QString bandString() const;
  void setBand( Band b ) { _band = b; }
  void setBand( const QString& b );

  Method method() const { return _method; }
  QString methodString() const;
  void setMethod( Method m ) { _method = m; }
  void setMethod( const QString& m );

  int order() const { return _order; }
  void setOrder( int o ) { _order = o; }

  bool causal() { return _order>0; }
  void setCausal( bool s ) { _order = ( s ? ::abs(_order) : -::abs(_order) ); }

  double width() const { return _width; }
  void setWidth( double w ) { _width = w; }
private:
  double _fmin, _fmax;
  union {
    int _order;     // for Butterworth
    double _width;  // for cosine taper filter
  };
  Band _band:4;
  Method _method:4;
};

} // namespace GeopsyCore

#endif // FILTERPARAMETERS_H
