/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2002-11-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYCOREBASE_H
#define GEOPSYCOREBASE_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "SignalFile.h"
#include "SignalFileFormat.h"

namespace GeopsyCore {

class SignalDB;
class GeopsyPrefs;
class Signal;
class SubSignalPool;
class SignalFile;
class DoubleSignal;
class KeepSignal;
class CustomAsciiFormats;
class SignalGroup;

class GEOPSYCORE_EXPORT GeopsyCoreBase : public GlobalObject
{
  TRANSLATIONS( "GeopsyCoreBase" )
public:
  GeopsyCoreBase();
  virtual ~GeopsyCoreBase();
  void clear();

  Cache * cache() { return _cache;}
  GeopsyPrefs * preferences() { return _preferences;}
  SignalDB * currentDB() {return _currentDB;}
  SignalDB * database( QString path );
  SignalFile * file( QString fileName );
  CustomAsciiFormats * customAsciiFormats() {return _customAsciiFormats;}

  SubSignalPool load(QString fileName, SignalFileFormat format=SignalFileFormat::Unknown, bool viewFile=false);
  SubSignalPool load(QStringList fileNames, SignalFileFormat format=SignalFileFormat::Unknown, bool viewFiles=false);
  void showSignal(const DoubleSignal * sig, const QString& name=QString::null, const QString& comments=QString::null);
  void showSignal(const KeepSignal * sig, const QString& name=QString::null, const QString& comments=QString::null);

  void setConsoleProgress( bool s );
  virtual bool useProgress() { return _progress; }
  virtual void setProgressMaximum( int val );
  virtual int progressMaximum() { if (_progress) return _progress->maximumValue(); else return 0; }
  virtual void setProgressValue( int val ) { if (_progress) _progress->setValue( val ); }
  virtual void increaseProgressValue( int val = 1 ) { if (_progress) _progress->increaseValue( val ); }
  virtual void showMessage( QString s );
  virtual void showLoadedSignals( const SubSignalPool& ) {}

  virtual void setGroupParent(SignalGroup * g, SignalGroup * parent) {Q_UNUSED(g); Q_UNUSED(parent);}

  // Inteface for loading signals
  virtual SignalFileFormat askLoadFormat(const QString& signalFileName);
  virtual bool askTimeReference(double& t0, QDateTime& timeRef, const QDateTime& timeTrue);
  virtual bool askRD3LogParameter(int& nSamples, double& sampFreq, double& t0);
protected:
  GeopsyPrefs * _preferences;
  Cache * _cache;
  QList<SignalDB *> _databases;
  SignalDB * _currentDB;
  CustomAsciiFormats * _customAsciiFormats;
  ConsoleProgress * _progress;
};

extern GEOPSYCORE_EXPORT GeopsyCoreBase * geopsyCore;

} // namespace GeopsyCore

#endif // GEOPSYCOREBASE_H
