/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-11-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GeopsyPrefs_H
#define GeopsyPrefs_H

#include "SignalData.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT GeopsyPrefs
{
  TRANSLATIONS("GeopsyPrefs");
public:
  GeopsyPrefs();
  ~GeopsyPrefs();

  // Loading preferences
  bool askForFormat() const {return _askForFormat;}
  SignalFileFormat fileFormat() const {return _fileFormat;}
  bool askForTimeReference() const {return _timeReference==AskTimeReference;}
  bool isFixedTimeReference() const {return _timeReference & FixedTimeReference;}
  bool isFixedDate() const {return _timeReference & FixedDate;}
  bool isFixedTime() const {return _timeReference & FixedTime;}
  QDate fixedDate() const {return _fixedDate;}
  QTime fixedTime() const {return _fixedTime;}
  bool isNoCommonTimeReference() const {return _timeReference==NoCommonTimeReference; }
  bool viewIfFewFiles() const {return _viewIfFewFiles;}
  int maxNofFiles() const {return _maxNofFiles;}
  bool showTable() const {return _showTable;}
  bool showGraphic() const {return _showGraphic;}
  bool oneWinPerFile() const {return _oneWinPerFile;}
  // Signal name
  bool stationNameFile() const {return _stationName==StationNameFile;}
  bool stationNameRxxx() const {return _stationName==StationNameRxxx;}
  // Saving preferences
  bool newFileAskDirectory() const {return _newFileDirectory==NewFileAskDirectory;}
  bool newFileDBDirectory() const {return _newFileDirectory==NewFileDBDirectory;}
  bool newFileFixedDirectory() const {return _newFileDirectory==NewFileFixedDirectory;}
  QDir newFilePath( bool ask, bool& ok );
  // Viewers tab
  SignalDataPool& tableFields() {return _tableFields;}
  bool restoreGraphicMakeUp() const {return _graphicMakeUp;}
  QString graphicMakeUpFile() const { return _graphicMakeUpFile; }
  bool restoreMapMakeUp() const {return _mapMakeUp;}
  QString mapMakeUpFile() const { return _mapMakeUpFile; }
  bool restoreChronogramMakeUp() const {return _chronogramMakeUp;}
  QString chronogramMakeUpFile() const { return _chronogramMakeUpFile; }
  // Cache preferences
  uint cacheSize() {return _cacheSize;}
  QString cacheSwapDir() {return _cacheSwapDir;}

  void load();
  void save();
  void saveNoAuto();
  void restoreFileDefaults();
  void restorePoolDefaults();
protected:
  // Flags
  uint _askForFormat:1;
  uint _timeReference:3;
  uint _showTable:1;
  uint _showGraphic:1;
  uint _oneWinPerFile:1;
  uint _viewIfFewFiles:1;
  uint _stationName:2;
  uint _newFileDirectory:2;
  uint _graphicMakeUp:1;
  uint _mapMakeUp:1;
  uint _chronogramMakeUp:1;
  uint _unused:17;

  enum TimeReference { AskTimeReference=0x0, FixedTimeReference=0x3, FixedDate=0x1, FixedTime=0x2, NoCommonTimeReference = 0x4 };
  enum StationName { StationNameFile=0x0, StationNameRxxx=0x1 };
  enum NewFileDirectory { NewFileAskDirectory=0x0, NewFileDBDirectory=0x1, NewFileFixedDirectory=0x2 };

  // Loading prefs values
  SignalFileFormat _fileFormat;
  QDate _fixedDate;
  QTime _fixedTime;
  int _maxNofFiles;
  // Saving prefs values
  QString _newFilePath;
  // Viewers prefs
  SignalDataPool _tableFields;
  QString _graphicMakeUpFile;
  QString _mapMakeUpFile;
  QString _chronogramMakeUpFile;
  // Cache preferences
  QString _cacheSwapDir;
  uint _cacheSize;
};

} // namespace GeopsyCore

#endif // GEOPSYPREFS_H
