/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYSIGNALHEADER_H
#define GEOPSYSIGNALHEADER_H

#include <QtCore>
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#define GEOPSYSIGNAL_TAG "GeopsySignal   "
#define GEOPSYSIGNAL_MAGICINT -2078964521
#define GEOPSYSIGNAL_MAGICFLOAT -333.3333333e33
#define GEOPSYSIGNAL_VERSION 2
#define GEOPSYSIGNAL_HEADERSIZE 16+8+4*4

#pragma pack(1)     // set alignment to 1 byte boundary

class GEOPSYCORE_EXPORT GeopsySignalHeader
{
public:
  bool isValid();

  union {
    char raw [GEOPSYSIGNAL_HEADERSIZE];
    struct {
      char tag[16];
      double magicFloat;
      qint32 magicInt;
      qint32 version;
      qint32 offset;
      qint32 nSignals;
    } field;
    struct {  // File header version 1
      char tag[10];
      qint32 version;
      qint32 offset;
      qint32 nSignals;
    } compat1;
  };
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // GEOPSYSIGNALHEADER_H
