/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-08-16
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GSE_H
#define GSE_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT Gse
{
  TRANSLATIONS("Gse")
public:
  static char * compress6( int nData, int * data, int& iComp );
  static bool decompress6( int nComp, const char * comp, int nData, int * data );
  static void diff(int * data, int nData);
  static void remdif(int * data, int nData);
  static int checksum( int * data, int nData );
private:
  inline static unsigned int ascii2gseChar(unsigned char c);
  inline static unsigned char gseChar2ascii(unsigned int c);
};

} // namespace GeopsyCore

#endif // GSE_H
