/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-26
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GURALPRECORDS_H
#define GURALPRECORDS_H

#include "SignalMember.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT GuralpRecords : public SignalMember
  {
  public:
    GuralpRecords() {}
    GuralpRecords(const GuralpRecords& o) : SignalMember(o), _records(o._records) {}

    virtual SignalMember * newCopy() {return new GuralpRecords(*this);}
    virtual QString toString(int) const;
    virtual void fromString(int , QString val);

    void add(quint64 pos) {_records.append(pos);}

    quint64 pos(int index) const {return _records[index];}
    int count() const {return _records.count();}
  private:
    QVector<quint64> _records;
  };

} // namespace GeopsyCore

#endif // GURALPRECORDS_H
