/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-26
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GURALPSIGNAL_H
#define GURALPSIGNAL_H

#include "GeopsyCoreDLLExport.h"
#include "GuralpCompressedBlock.h"
#include "GuralpRecords.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT GuralpSignal
  {
  public:
    GuralpSignal(quint64 offset, const GuralpCompressedBlock& b);

    void addRecord(quint64 offset, const GuralpCompressedBlock& b);

    QDateTime startTime() const {return _firstBlock.startTime();}
    SparseTimeRange timeRange(double t0) const;
    double samplingFrequency() const {return _firstBlock.samplingFrequency();}
    QString name() const {return _firstBlock.name();}
    Signal::Components component() const {return _firstBlock.component();}
    int nSamples() const {return _nSamples;}
    const GuralpRecords& records() const {return _records;}
  private:
    GuralpCompressedBlock _firstBlock;
    GuralpRecords _records;
    int _nSamples;
    SparseTimeRange _timeRange;
  };

} // namespace GeopsyCore

#endif // GURALPSIGNAL_H
