/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-12-12
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef KEEPSIGNAL_H
#define KEEPSIGNAL_H

#include "SignalTemplate.h"
#include "TimeRange.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class Signal;

class GEOPSYCORE_EXPORT KeepSignal : public SignalTemplate<int>
{
public:
  KeepSignal();
  KeepSignal( int n );
  KeepSignal( const KeepSignal& o );

  // Properties
  double deltaT() const { return _deltaT;}
  void setDeltaT( double newval ) {_deltaT = newval;}
  double samplingFrequency() const {return 1.0/_deltaT;}
  double duration() const { return _deltaT * _nSamples;}
  double t0() const { return _t0;}
  void setT0( double t ) {_t0 = t;}
  double endTime() const { return _t0 + _deltaT * _nSamples;}
  TimeRange timeRange() const { return TimeRange( _t0, endTime()); }

  void debugPrint() const;
private:
  double _deltaT;
  double _t0;
};

} // namespace GeopsyCore

#endif // KEEPSIGNAL_H
