/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-10-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDREADER_H
#define MINISEEDREADER_H

#include <QGpCoreTools.h>

#include "MiniSeedRecords.h"

namespace GeopsyCore {

class MiniSeedRecords;

class MiniSeedReader
{
  TRANSLATIONS("MiniSeedReader")
public:
  MiniSeedReader(QString fileName, const MiniSeedRecords * records);
  ~MiniSeedReader();

  enum Type {Text, Integer, Float, Double};
  void * record(int index, Type& t, int& nSamples);
  int recordCount() const {return _records->count();}
private:
  const MiniSeedRecords * _records;
  QFile * _f;
  LibMSeed::MSRecord * _msr;
};

} // namespace GeopsyCore

#endif // MINISEEDREADER_H
