/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-10-19
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDRECORDS_H
#define MINISEEDRECORDS_H

#include "SignalMember.h"

namespace GeopsyCore {

class MiniSeedRecords : public SignalMember
{
public:
  MiniSeedRecords() {}
  MiniSeedRecords(int n) : _records(n) {}
  MiniSeedRecords(const MiniSeedRecords& o) : SignalMember(o), _records(o._records) {}

  virtual SignalMember * newCopy() {return new MiniSeedRecords(*this);}
  virtual QString toString(int ) const;
  virtual void fromString(int , QString val);

  void setPos( int index, off_t pos ) { _records[index].pos = pos; }
  off_t pos( int index) const { return _records[index].pos; }

  void setByteLength( int index, qint32 byteLength ) { _records[index].byteLength = byteLength; }
  qint32 byteLength( int index ) const { return _records[index].byteLength; }

  int count() const { return _records.count(); }
private:
  struct Record {
    off_t pos;
    qint32 byteLength;
  };
  QVector<Record> _records;
};

} // namespace GeopsyCore

#endif // MINISEEDRECORDS_H
