/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-10-19
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MINISEEDTRACE_H
#define MINISEEDTRACE_H

#include "GeopsyCoreDLLExport.h"
#include "MiniSeedRecords.h"

#include <mseed.h>

namespace GeopsyCore {

class MiniSeedTrace
{
  MiniSeedTrace( const MiniSeedTrace& t );
public:
  MiniSeedTrace( LibMSeed::MSRecord * msr );
  ~MiniSeedTrace();

  void addRecord( LibMSeed::MSRecord * msr, off_t pos );
  bool belongsTo( LibMSeed::MSRecord * msr );
  MiniSeedTrace * split();

  double samplingFrequency() const { return _samplingFrequency; }
  QString channel() const { return _channel; }
  QString network() const { return _network; }
  QString station() const { return _station; }
  QString location() const { return _location; }

  QDateTime startTime() const { return _records.first()->_startTime; }
  double t0() const { return _records.first()->_t0; }
  int nSamples() const;
  MiniSeedRecords records() const;
private:
  double _samplingFrequency, _deltaT;
  QString _network, _station, _location, _channel;

  void splitOverlapping( int firstRecord, MiniSeedTrace * sig );
  class Record
  {
  public:
    static bool lessThan(const Record * r1, const Record * r2) {
      return r1->_startTime < r2->_startTime || ( r1->_startTime == r2->_startTime && r1->_t0 < r2->_t0 );
    }

    int _nSamples;
    QDateTime _startTime;
    double _t0;
    off_t _pos;
    qint32 _byteLength;
  };
  QList<Record *> _records;
  bool _sorted;
};

} // namespace GeopsyCore

#endif // MINISEEDTRACE_H
