/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-09-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MORLETPARAMETERS_H
#define MORLETPARAMETERS_H

#include <math.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT MorletParameters
{
public:
  void operator=(const MorletParameters& o);

  void setFi(double v) { _fi=v; }
  void setM(double v) { _m=v; }

  double fi() const { return _fi; }
  double m() const { return _m; }

  double deltaT() const;
  double deltaF() const;
private:
  double _fi;
  double _m;
};

} // namespace GeopsyCore

#endif // MORLETPARAMETERS_H
