/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2007-03-09
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef NORMALIZATIONPARAM_H
#define NORMALIZATIONPARAM_H

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT NormalizationParam
{
public:
  NormalizationParam();

  enum Type {None, SurfaceAttenuation, VolumeAttenuation, MaximumAmplitude, SpectrumEnergy};

  void setType( Type t );
  Type type() const { return _type; }

  void setRange( double min, double max);
  double minimumFrequency() const { return _minF; }
  double maximumFrequency() const { return _maxF; }
private:
  Type _type;
  double _minF, _maxF;
};

} // namespace GeopsyCore

#endif // NORMALIZATIONPARAM_H
