/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SACHEADER_H
#define SACHEADER_H

#include "SignalFile.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     /* set alignment to 1 byte boundary */

class GEOPSYCORE_EXPORT SACHeader
{
public:
  SACHeader();

  static SignalFileFormat determineByteOrder(QString fileName);

  void read(QDataStream& s);
  bool write(QDataStream& s);

  QDateTime startTime() const;
  union {
    float raw [70];
    struct {
      float DELTA;      // 0
      float DEPMIN;
      float DEPMAX;
      float SCALE;
      float ODELTA;
      float B;          // 5
      float E;
      float O;
      float A;
      float INTERNAL0;
      float T[10];      // 10
      float F;          // 20
      float RESP0;
      float RESP1;
      float RESP2;
      float RESP3;
      float RESP4;      // 25
      float RESP5;
      float RESP6;
      float RESP7;
      float RESP8;
      float RESP9;      // 30
      float STLA;
      float STLO;
      float STEL;
      float STDP;
      float EVLA;       // 35
      float EVLO;
      float EVEL;
      float EVDP;
      float MAG;
      float USER0;      // 40
      float USER1;
      float USER2;
      float USER3;
      float USER4;
      float USER5;      // 45
      float USER6;
      float USER7;
      float USER8;
      float USER9;
      float DIST;       // 50
      float AZ;
      float BAZ;
      float GCARC;
      float INTERNAL1;
      float INTERNAL2;  // 55
      float DEPMEN;
      float CMPAZ;
      float CMPINC;
      float XMINIMUM;
      float XMAXIMUM;   // 60
      float YMINIMUM;
      float YMAXIMUM;
      float UNUSED0;
      float UNUSED1;
      float UNUSED2;    // 65
      float UNUSED3;
      float UNUSED4;
      float UNUSED5;
      float UNUSED6;
    } field;
  } floats;
  union {
    qint32 raw [35];
    struct {
      qint32 NZYEAR;          // 70
      qint32 NZJDAY;
      qint32 NZHOUR;
      qint32 NZMIN;
      qint32 NZSEC;
      qint32 NZMSEC;          // 75
      qint32 NVHDR;           //      Header version number [required]
      qint32 NORID;
      qint32 NEVID;
      qint32 NPTS;
      qint32 INTERNAL;       // 80
      qint32 NWFID;
      qint32 NXSIZE;
      qint32 NYSIZE;
      qint32 UNUSED0;
      qint32 IFTYPE;         // 85
      qint32 IDEP;
      qint32 IZTYPE;
      qint32 UNUSED1;
      qint32 IINST;
      qint32 ISTREG;         // 90
      qint32 IEVREG;
      qint32 IEVTYP;
      qint32 IQUAL;
      qint32 ISYNTH;
      qint32 IMAGTYP;        // 95
      qint32 IMAGSRC;
      qint32 UNUSED2;
      qint32 UNUSED3;
      qint32 UNUSED4;
      qint32 UNUSED5;        // 100
      qint32 UNUSED6;
      qint32 UNUSED7;
      qint32 UNUSED8;
      qint32 UNUSED9;
    } field;
  } ints;
  union {
    quint32 raw [5];
    struct {
      quint32 LEVEN;          // 105
      quint32 LPSPOL;
      quint32 LOVROK;
      quint32 LCALDA;
      quint32 UNUSED;
    } field;
  } bools;
  union {
    char raw [192];
    struct {
      char KSTNM [8];     // 110
      char KEVNM [16];
      char KHOLE [8];     // 116
      char KO [8];
      char KA [8];
      char KT0 [8];       // 122
      char KT1 [8];
      char KT2 [8];
      char KT3 [8];       // 128
      char KT4 [8];
      char KT5 [8];
      char KT6 [8];       // 134
      char KT7 [8];
      char KT8 [8];
      char KT9 [8];       // 140
      char KF [8];
      char KUSER0 [8];
      char KUSER1 [8];    // 146
      char KUSER2 [8];
      char KCMPNM [8];
      char KNETWK [8];    // 152
      char KDATRD [8];
      char KINST [8];
    } field;
  } chars;
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SACHEADER_H
