/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-03-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALDB_H
#define SIGNALDB_H

#include <QGpCoreTools.h>
#include "SubSignalPool.h"
#include "SignalFilePool.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#define SIGNALDB_CURRENT_VERSION 3

class SubSignalPool;
class SignalGroup;

class GEOPSYCORE_EXPORT SignalDB : private SubSignalPool, public XMLClass
{
  TRANSLATIONS( "SignalDB" );
public:
  SignalDB();
  ~SignalDB();

  virtual const QString& xml_tagName() const {return xmlSignalDBTag;}
  static const QString xmlSignalDBTag;

  void saveAs( QString fileName = QString::null );
  void save();
  bool open( QString fileName = QString::null );
  QDir newFilePath(QDir d);

  bool exists() const { return !name().isEmpty(); }
  QString name() const { return SubSignalPool::name(); }
  int version() const { return _version; }

  bool contains( Signal * sig ) const { return SubSignalPool::contains(sig); }
  Signal * findSignal( int id ) const;
  void addSignal( Signal * sig );
  void addFile( SignalFile * file );
  SignalFilePool& filePool() { return _files;}
  const SubSignalPool& subPool() const { return *this; }

  SignalGroup * findGroup( QString name ) const;
  SignalGroup * superGroup() const { return _superGroup; }
  bool isModified();
  void removeFile(SignalFile * f);
  void removeSignal(Signal * sig) {SubSignalPool::remove(sig);}
  void signalDeleted(Signal * sig);

  int uniqueId( int requestedId );
  int count() const { return SubSignalPool::count();}
  Signal * at( int index ) const { return SubSignalPool::at( index );}
protected:
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
  void xml_polish(XML_POLISH_ARGS);
private:
  Message::Answer newFilePath(QDir& d, QString msg);
  bool saveTemporaryFiles();
  bool saveTemporarySignals();
  int countId( int id );

  bool openDBFileV12( QString fileName );
  bool openDBFileV2( FILE * f );
  void openGroupsV12();

  SignalFilePool _files;
  SignalGroup * _superGroup;
  int _newId;
  int _version;
  QMap<int, int> * _translateId;
};

} // namespace GeopsyCore

#endif // SIGNALDB_H
