/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-11-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SignalData_H
#define SignalData_H

#include "GeopsyCoreDLLExport.h"
#include "Signal.h"

namespace GeopsyCore {

class SignalDataPool;

class GEOPSYCORE_EXPORT SignalData
{
public:
  SignalData() {}
  ~SignalData() {}

  static void init();
  static QString defaultTitle(Signal::DataIndex d);
  static QString dataID2Name(Signal::Data d);
  static QString dataIndex2Name(Signal::DataIndex d);
  static bool isValidDataName(QString name);
  static bool isArrayData(Signal::Data d);
  static Signal::Data dataName2ID(QString name) {return _names2IDMap.value(name);}
  static Signal::DataIndex dataName2Index(QString name);

  void setId(Signal::Data id) {_data._id=id;}
  Signal::Data id() const {return _data._id;}

  void setIndex(int index) {_data._index=index;}
  int index() const {return _data._index;}

  void setDataIndex(Signal::DataIndex d) {_data=d;}
  const Signal::DataIndex& dataIndex() const {return _data;}

  void setCompleteName(QString n) {_data=dataName2Index(n);}
  QString completeName() const {return dataIndex2Name(_data);}

  void setName(QString n) {_data._id=dataName2ID(n);}
  QString name() const {return dataID2Name(_data._id);}

  void setDefaultTitle() {_title = SignalData::defaultTitle(_data._id); }
  void setTitle(QString t) {_title = t;}
  QString title() const {return _title;}

  bool isReadOnly() {return Signal::isReadOnlyData(_data);}
  bool isStored() {return Signal::isStoredData(_data);}
private:
  friend class SignalDataPool;
  Signal::DataIndex _data;
  QString _title;
  static QMap<QString, Signal::Data> _names2IDMap;
};

class GEOPSYCORE_EXPORT SignalDataPool : private QList<SignalData>
{
public:
  SignalDataPool() {}
  ~SignalDataPool() {}

  typedef QList<SignalData>::iterator iterator;
  iterator begin() { return QList<SignalData>::begin();}
  iterator end() { return QList<SignalData>::end();}
  typedef QList<SignalData>::const_iterator const_iterator;
  const_iterator begin() const { return QList<SignalData>::begin();}
  const_iterator end() const { return QList<SignalData>::end();}

  void readRegistry(QSettings& reg);
  void writeRegistry(QSettings& reg) const;

  void setDefaults();
  void setAll();

  void clear() { QList<SignalData>::clear(); }
  void add ( Signal::Data id, int index = 0 );
  void add ( const SignalData& d ) {append(d);}
  const SignalData& at(int index) const {return QList<SignalData>::at(index);}
  int count() const {return QList<SignalData>::count();}
};

} // namespace GeopsyCore

#endif // SIGNALDATA_H
