/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-10-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALFILEFORMAT_H
#define SIGNALFILEFORMAT_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class AsciiSignalFormat;

class GEOPSYCORE_EXPORT SignalFileFormat
{
public:
  // Be careful, for the sake of compatibility with older databases, never
  // change the order of the following enumeration. Only append. This is not valid for new db.
  enum Format {
    Unknown = 0,
    Seg2,
    SuLittleEndian,
    SuBigEndian,
    Tomo,
    RD3,
    NiSismo,
    SacLittleEndian,
    SacBigEndian,
    Radan,
    Gse2,
    City2,
    Ascii,
    GeopsySignal,
    Saf,
    MultiGse2,
    Sismalp,
    Wav,
    SegYLittleEndian,
    SegYBigEndian,
    Temporary,
    SyscomXmr,
    SyscomSmr,
    SyscomVmrx,
    GuralpGcf,
    AsciiGeoSig,
    MiniSeed,
    AsciiOneColumn,
    PasscalSegYBigEndian,
    PasscalSegYLittleEndian,
    FormatCount  // Must be the last one, used to count the available file formats
  };
  enum Storage {Single, Multi};

  SignalFileFormat(Format f=Unknown, AsciiSignalFormat * asciiFormat=0);
  SignalFileFormat(const SignalFileFormat& o);
  ~SignalFileFormat();

  void operator=(const SignalFileFormat& o);
  bool operator==(const SignalFileFormat& o) const;
  bool operator<(const SignalFileFormat& o) const;

  Format id() const {return _id;}
  const AsciiSignalFormat * asciiFormat() const {return _asciiFormat;}
  bool isReadOnly() const;
  Storage storage() const;

  QString toString() const;
  QString caption() const;
  QString captionFilter() const;
  QString filter() const;
  QString suffix() const;

  static SignalFileFormat fromContent(QString fileName);
  static SignalFileFormat fromSuffix(QString fileName);
  static SignalFileFormat fromString(QString f);
  static QList< QPair<QString, SignalFileFormat> > importList();
private:
  Format _id;
  AsciiSignalFormat * _asciiFormat;
};

#define SIGNALFILEFORMAT_READONLY \
  case SignalFileFormat::RD3: \
  case SignalFileFormat::NiSismo: \
  case SignalFileFormat::Radan: \
  case SignalFileFormat::City2: \
  case SignalFileFormat::Sismalp: \
  case SignalFileFormat::SegYLittleEndian: \
  case SignalFileFormat::SegYBigEndian: \
  case SignalFileFormat::PasscalSegYLittleEndian: \
  case SignalFileFormat::PasscalSegYBigEndian: \
  case SignalFileFormat::Temporary: \
  case SignalFileFormat::SyscomXmr: \
  case SignalFileFormat::SyscomSmr: \
  case SignalFileFormat::SyscomVmrx: \
  case SignalFileFormat::GuralpGcf: \
  case SignalFileFormat::AsciiGeoSig: \
  case SignalFileFormat::FormatCount: \
  case SignalFileFormat::Unknown:

} // namespace GeopsyCore

#endif // SIGNALFILEFORMAT_H
