/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-11-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALFILEPOOL_H
#define SIGNALFILEPOOL_H

#include <QGpCoreTools.h>
#include "GeopsyCoreDLLExport.h"
#include "SignalFile.h"
#include "SignalFileFormat.h"

namespace GeopsyCore {

class SignalDB;

class GEOPSYCORE_EXPORT SignalFilePool : private QList<SignalFile *>
{
  TRANSLATIONS("SignalFilePool")
public:
  SignalFilePool(SignalDB * db) { _db=db; }
  ~SignalFilePool();

  typedef QList<SignalFile *>::iterator iterator;
  typedef QList<SignalFile *>::const_iterator const_iterator;
  SignalFile * last() const {return QList<SignalFile *>::last();}
  SignalFile * at( int index ) const {return QList<SignalFile *>::at( index );}
  int indexOf( SignalFile * f ) const {return QList<SignalFile *>::indexOf(f);}
  int count() const {return QList<SignalFile *>::count();}
  const_iterator begin() const {return QList<SignalFile *>::begin();}
  const_iterator end() const {return QList<SignalFile *>::end();}
  iterator begin() {return QList<SignalFile *>::begin();}
  iterator end() {return QList<SignalFile *>::end();}

  SignalFile * find( QString fileName );
  bool load(QString name, SignalFileFormat format=SignalFileFormat::Unknown );
private:
  friend class SignalDB;
  void clear();
  void remove ( SignalFile * f );
  void insert( int before, SignalFile * f ) {QList<SignalFile *>::insert( before, f );}
  void move( int from, int to) { QList<SignalFile *>::move( from, to);}
  void append( SignalFile * f ) {QList<SignalFile *>::append( f );}
  SignalDB * _db;
};

} // namespace GeopsyCore

#endif // SIGNALFILEPOOL_H
