/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-03-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALGROUP_H
#define SIGNALGROUP_H

#include <QGpCoreTools.h>
#include "SubSignalPool.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class Signal;
class SignalDB;

class GEOPSYCORE_EXPORT SignalGroup : public TreeItem
{
  TRANSLATIONS("SignalGroup")
public:
  SignalGroup( SignalGroup * parent=0 ) : TreeItem( parent ) {}
  SignalGroup( QString name, SignalGroup * parent=0 );
  SignalGroup( const SubSignalPool& subPool, const SignalDB * db );

  virtual const QString& xml_tagName() const {return xmlSignalGroupTag;}
  static const QString xmlSignalGroupTag;

  QString name() const { return _cache.name(); }
  void setName( QString n ) { if ( n!=name() ) setModified(true); _cache.setName(n); }
  QString pathName() const;

  QString comments() const {return _comments;}
  void setComments(QString c) { if (c!=comments()) setModified(true); _comments=c;}

  SignalGroup * find( QString name ) const;
  QList<SignalGroup *> find( Signal * sig ) const;

  int signalCount() const;
  const SubSignalPool& subPool( const SignalDB * db );
  void remove( Signal * sig );
  void setSignals(const SubSignalPool& subPool, const SignalDB * db);
  void addSignals(const SubSignalPool& subPool, const SignalDB * db);
  bool translateIds( const QMap<int,int>& translator );

  static bool lessThan( SignalGroup * g1, SignalGroup * g2 );

  void clearCache();
  void openV12( int dbVersion, const QDir& dbPath, QMap<int, int> * tranlateID = 0 );

  SignalGroup * parent() const { return static_cast<SignalGroup *>(TreeItem::parent()); }
  SignalGroup * childAt(int index) { return static_cast<SignalGroup *>(TreeItem::childAt(index)); }
  SignalGroup * folderAt(int index) { return static_cast<SignalGroup *>(TreeItem::folderAt(index)); }

  void list( QString prefix );
protected:
  virtual TreeItem * createNewItem( TreeItem * parent ) {
    return new SignalGroup(static_cast<SignalGroup *>(parent));
   }

  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
private:
  void find( QList<SignalGroup *>& groups, Signal * sig ) const;

  SubSignalPool _cache;
  QList<int> _ids;
  QString _comments;
};

inline bool SignalGroup::lessThan( SignalGroup * g1, SignalGroup * g2 )
{
  TRACE;
  return g1->name()<g2->name();
}

} // namespace GeopsyCore

#endif // SIGNALGROUP_H
