/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-05-05
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SIGNALPROCESSSCRIPT_H
#define SIGNALPROCESSSCRIPT_H

#include "SignalProcess.h"
#include "GeopsyCoreDLLExport.h"

class QScriptEngine;
class QScriptValue;
class QScriptContext;

namespace GeopsyCore {

class GEOPSYCORE_EXPORT SignalProcessScript : public SignalProcess
{
public:
  SignalProcessScript( QObject * parent = 0 );

  bool run( const QString& script );
private:
  static QScriptValue saveScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue restoreScript( QScriptContext *context, QScriptEngine *engine );

  static QScriptValue fastFourierTransformScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue exportFileScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue headerScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue setHeaderScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue signalCountScript( QScriptContext *context, QScriptEngine *engine );

  static QScriptValue subtractValueScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue subtractSignalScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue subtractSignalsScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue multiplyScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue filterScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue agcScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue whitenScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue stddevClipScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue shiftScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue overSampleScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue taperScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue cutScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue mergeScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue mergeStationsScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue decimateAmplitudeScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue decimateTimeScript( QScriptContext *context, QScriptEngine *engine );

  static QScriptValue waveletTransformScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue staltaScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue discreteFourierTransformScript( QScriptContext *context, QScriptEngine *engine );

  static QScriptValue rotateComponentsScript( QScriptContext *context, QScriptEngine *engine );
  static QScriptValue correlationsScript( QScriptContext *context, QScriptEngine *engine );

  static QScriptValue argumentsToTimeRange( RelativeTimeRange& param, QScriptContext *context,
                                            int startIndex, int endIndex );

  static QScriptValue systemScript( QScriptContext *context, QScriptEngine *engine );

  QScriptEngine * _engine;
};

} // namespace GeopsyCore

#endif // SIGNALPROCESSSCRIPT_H
