/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-06-02
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPARSEKEEPSIGNAL_H
#define SPARSEKEEPSIGNAL_H

#include <QGpCoreTools.h>
#include "GeopsyCoreDLLExport.h"
#include "SparseTimeRange.h"

namespace GeopsyCore {

class KeepSignal;

class GEOPSYCORE_EXPORT SparseKeepSignal : private SparseTimeRange
{
  TRANSLATIONS("SparseKeepSignal")
public:
  SparseKeepSignal();
  SparseKeepSignal(const SparseTimeRange& r);
  SparseKeepSignal(const SparseKeepSignal& o);
  ~SparseKeepSignal();

  bool setSampling(const TimeRange& r, double deltaT);
  void initValues(int value, double start=-1e99, double end=1e99);
  void copySamplesFrom(const SparseKeepSignal& o);

  SparseKeepSignal * intersection(const TimeRange& r) const;
  void remove(const TimeRange& r);

  SparseTimeRange timeRange() const {return *this;}
  QVector<KeepSignal *> keeps(const TimeRange& r) const;
  const QVector<KeepSignal *>& keeps() const {return _keeps;}

  void printDebug() const {SparseTimeRange::printDebug();}
private:
  static KeepSignal * cutStart( const KeepSignal * keep, double t );
  static KeepSignal * cutEnd( const KeepSignal * keep, double t );

  QVector<KeepSignal *> _keeps;
};

} // namespace GeopsyCore

#endif // SPARSEKEEPSIGNAL_H
