/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-07-10
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONLIST_H
#define STATIONLIST_H

#include <QGpCoreTools.h>
#include "GeopsyCoreDLLExport.h"
#include "StationSignals.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT StationList : public QList<StationSignals *>
{
  TRANSLATIONS("StationList")
public:
  StationList();
  virtual ~StationList();

  bool addSignal( Signal * sig, QString * log = 0 );
  bool addSignals( SubSignalPool * subPool, QString * log = 0 );

  void setComponents( StationSignals::Components c );
  bool hasAllComponents( QString * log = 0 ) const;

  StationSignals::Components components() const { return _components; }
  int nComponents() const { return StationSignals::nComponents( _components ); }
  Signal::Components component( int index ) const { return StationSignals::component(index, _components); }

  QList<NamedPoint> pointList() const;
private:
  StationSignals::Components _components;
};

} // namespace GeopsyCore

#endif // STATIONLIST_H
