/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-02-21
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONPROCESSSIGNALS_H
#define STATIONPROCESSSIGNALS_H

#include "GeopsyCoreDLLExport.h"
#include "StationSignals.h"

namespace GeopsyCore {

class AbstractParameters;

class GEOPSYCORE_EXPORT StationProcessSignals
{
  TRANSLATIONS("StationProcessSignals")
public:
  StationProcessSignals( const StationSignals * originalSignals );
  virtual ~StationProcessSignals();

  int nComponents() const { return _originals->nComponents(); }
  const StationSignals * originalSignals() const { return _originals; }

  void setHighPassFilter( double frequency );

  virtual void setProcessed( const TimeRange& tw, AbstractParameters * param ) = 0;
  DoubleSignal * processed ( int iComp ) const { return _signals[iComp].processed; }
  DoubleSignal *& processed( int iComp ) { return _signals[iComp].processed; }
  const double * processedSamples( int iComp ) { return _signals[iComp].processedSamples; }

  bool lockSamples();
  void unlockSamples();

protected:
  void copyOriginalSignal( int iComp, const TimeRange& tw );
private:
  const StationSignals * _originals;
  class ComponentSignals {
  public:
    ComponentSignals() { processed=0; merged=0; filtered=0;processedSamples=0; }
    QList<DoubleSignal *> * merged;
    QList<DoubleSignal *> * filtered;
    DoubleSignal * processed;
    const double * processedSamples;
  };
  ComponentSignals * _signals;

  bool setKeep( int iComp, const TimeRange& tw, const WindowingParameters& param, int stationIndex );
};

} // namespace GeopsyCore

#endif // STATIONPROCESSSIGNALS_H
