/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SYSCOMHEADER_H
#define SYSCOMHEADER_H

#include "Signal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     /* set alignment to 1 byte boundary */

class GEOPSYCORE_EXPORT SyscomHeader
{
public:
  static Signal::Components component( int channel );
protected:
  struct Time {
    uchar SECOND;
    uchar MINUTE;
    uchar HOUR;
    uchar DAY;
    uchar MONTH;
    uchar YEAR;
  };
  struct Lsb {
    qint16 MANTISSA;
    char EXPONENT;
  };
  static QDateTime startTime( const Time& t );
  static int bcd2int( uchar bcd );
  static double countPerVolt( const Lsb& l );
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SYSCOMHEADER_H
