/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SYSCOMSVMRXHEADER_H
#define SYSCOMSVMRXHEADER_H

#include "SyscomHeader.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     // set alignment to 1 byte boundary

class GEOPSYCORE_EXPORT SyscomSVmrxHeader : public SyscomHeader
{
public:
  SyscomSVmrxHeader();

  QDateTime startTime() const { return SyscomHeader::startTime(field.SYNC_TIME); }
  double countPerVolt( int channel ) const { return SyscomHeader::countPerVolt( field.LSB[channel] ); }

  union {
    char raw [256];
    struct {
      char UNUSED1[6];     // 0
      qint32 NB_SAMPLES;   // 6
      qint16 SAMPLING;     // 10
      uchar NB_CHANNEL;    // 12
      char UNUSED2[12];
      uchar CHECK_SUM;     // 25
      uchar SW_REVISION;   // 26
      char SS_NUMBER[5];   // 27
      qint32 SYNC_OFFSET;  // 32
      Time SYNC_TIME;      // 36
      uchar SYNC_OK;
      qint16 INT_OFFSET;   // 43
      Time INT_TIME;      // 45
      char UNUSED3[13];
      char REC_NAME[7];    // 64
      char S_NUMBER[5];    // 71
      char UNUSED4[18];
      Lsb LSB[3];          // 94
      char UNUSED5[9];
      char CH_UNIT_X[5];     // 112
      char CH_UNIT_Y[5];
      char CH_UNIT_Z[5];
      char UNUSED6[15];
      char CH_NAME_X[3];     // 142
      char CH_NAME_Y[3];
      char CH_NAME_Z[3];
      char UNUSED7[99];     // 151
      char ENGG_MODE;       // 250  Always 0 for SMR, 0 to 6 for VMR/VMX
      char UNUSED8[5];
    } field;
  };
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SYSCOMSVMRXHEADER_H
