/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-12-11
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TIMERANGELIST_H
#define TIMERANGELIST_H

#include <QGpCoreTools.h>
#include "TimeRange.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class WindowingParameters;
class SparseKeepSignal;

class GEOPSYCORE_EXPORT TimeRangeList: private QList<TimeRange *>
{
  TRANSLATIONS("TimeRangeList")
public:
  TimeRangeList() {}
  TimeRangeList(const TimeRangeList& o, int firstIndex);
  virtual ~TimeRangeList();

  void add(double frequency, const WindowingParameters& param, const SparseKeepSignal& keep, const TimeRange& r, QString * log);
  void addBlanks(double frequency, const WindowingParameters& param, const SparseKeepSignal& keep, const TimeRange& r, QString * log);
  void addOne(const TimeRange& r) {append(newTimeRange(r.start(), r.end()));}
  TimeRange& addOne() {TimeRange * r=newTimeRange(0.0, 0.0); append(r); return *r;}
  void add(QTextStream& s, QString * log);
  void add(const TimeRangeList& list);
  void remove(const TimeRange& r, QString * log);
  void remove(int index, QString * log);
  void inverse(double frequency, const WindowingParameters& param, const SparseKeepSignal& keep, const TimeRange& r, QString * log);
  QString toString() const;
  bool clear();
  int count() const {return QList<TimeRange *>::count();}
  bool isEmpty() const {return QList<TimeRange *>::isEmpty();}

  typedef QList<TimeRange *>::iterator iterator;
  typedef QList<TimeRange *>::const_iterator const_iterator;
  iterator begin() { return QList<TimeRange *>::begin();}
  iterator end() { return QList<TimeRange *>::end();}
  const_iterator begin() const { return QList<TimeRange *>::begin();}
  const_iterator end() const { return QList<TimeRange *>::end();}

  const TimeRange& at(int index) const {return *QList<TimeRange *>::at(index);}
  TimeRange& at(int index) {return *QList<TimeRange *>::operator[](index);}

  // Query information on list
  double longestWindow() const;
  TimeRange timeRange() const;
protected:
  virtual TimeRange * newTimeRange(double start, double end) {return new TimeRange(start, end);}
  virtual TimeRange * cloneTimeRange(TimeRange * r) {return new TimeRange(*r);}
  virtual void deleteTimeRange(TimeRange * r) {delete r;}
  void internalClear() {QList<TimeRange *>::clear();}
private:
  void blanksToKeep(SparseKeepSignal& keep, double overlap) const;
};

} // namespace GeopsyCore

#endif // TIMERANGELIST_H
