/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-08-26
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WAVEHEADER_H
#define WAVEHEADER_H

#include <QGpCoreTools.h>
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     // set alignment to 1 byte boundary

struct GEOPSYCORE_EXPORT WaveHeader
{
  // The canonical WAVE format starts with the RIFF header:
  char chunkID[ 4 ]; // Contains the letters "RIFF" in ASCII form
  qint32 chunkSize; // 36 + subChunk2Size, This is the size of the rest of the chunk
  char format[ 4 ]; // Contains the letters "WAVE"
  // The "WAVE" format consists of two subchunks: "fmt " and "data":
  // The "fmt " subchunk describes the sound data's format:
  char subchunk1ID[ 4 ]; // Contains the letters "fmt "
  qint32 subchunk1Size; /* 16 for PCM.  This is the size of the
                          rest of the subchunk which follows this number. */
  qint16 audioFormat; /* PCM = 1 (i.e. Linear quantization)
                          Values other than 1 indicate some
                          form of compression. */
  qint16 numChannels; // Mono = 1, Stereo = 2, etc.
  qint32 sampleRate; // 8000, 44100, etc.
  qint32 byteRate; // == sampleRate * numChannels * bitsPerSample/8
  qint16 blockAlign; /* == NumChannels * BitsPerSample/8
                         The number of bytes for one sample including
                         all channels. I wonder what happens when
                         this number isn't an integer? */
  qint16 bitsPerSample; // 8 bits = 8, 16 bits = 16, etc.
  // The "data" subchunk contains the size of the data and the actual sound:
  char subchunk2ID[ 4 ]; // Contains the letters "data"
  qint32 subchunk2Size; /* == NumSamples * NumChannels * BitsPerSample/8
                          This is the number of bytes in the data.
                          You can also think of this as the size
                          of the read of the subchunk following this
                          number. */
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // WAVEHEADER_H
