/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-12-19
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef WINDOWINGPARAMETERS_H
#define WINDOWINGPARAMETERS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"
#include "FilterParameters.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT WindowingParameters
{
public:
  WindowingParameters();
  ~WindowingParameters();

  void operator=( const WindowingParameters& o );
  enum LengthType {Exactly, AtLeast, FreqDep};

  struct SLtaParam
  {
    bool doIt;
    double tsta;
    double tlta;
    double seuilMin;
    double seuilMax;
  };

  void setNComponents( int n );
  int nComponents() const { return _nComponents;}

  void setNStations( int n );
  int nStations() const { return _nStations;}

  void setRawComponent( int comp, bool b ) { ASSERT(comp<_nComponents); _rawComponent[comp]=b;}
  void setFiltComponent( int comp, bool b ) { ASSERT(comp<_nComponents); _filtComponent[comp]=b;}
  void setRawStation( int stat, bool b ) { ASSERT(stat<_nStations); _rawStation[stat]=b;}
  void setFiltStation( int stat, bool b ) { ASSERT(stat<_nStations); _filtStation[stat]=b;}

  bool rawComponent( int comp ) const { return comp < _nComponents ? _rawComponent[comp] : true;}
  bool filtComponent( int comp ) const { return comp < _nComponents ? _filtComponent[comp] : true;}
  bool rawStation( int stat ) const { return stat < _nStations ? _rawStation[stat] : true;}
  bool filtStation( int stat ) const { return stat < _nStations ? _filtStation[stat] : true;}

  bool needFilt() const;

  void setTMinMax( double tmin, double tmax );
  void setTFixed( double t );
  void setTFreqDep( double nPeriod );

  double minLength( double frequency ) const;
  double maxLength( double frequency ) const;
  double periodNum() const { return _periodNum;}

  bool isValid();
  void printDebug();
public:
  double overlap;
  int percClip;
  double badTol;
  SLtaParam rawSignal;
  SLtaParam filtSignal;
  FilterParameters filter;
protected:
  int _nComponents, _nStations;
  bool * _rawComponent;
  bool * _filtComponent;
  bool * _rawStation;
  bool * _filtStation;

  LengthType _lengthType;
  double _tmin;
  double _tmax;
  double _periodNum;
};

} // namespace GeopsyCore

#endif // WINDOWINGPARAMETERS_H
