/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-03-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLSIGNAL_H
#define XMLSIGNAL_H

#include <QGpCoreTools.h>

#include "Signal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT XMLSignal : public XMLClass
{
public:
  XMLSignal();
  XMLSignal(Signal * sig);
  ~XMLSignal() {}

  virtual const QString& xml_tagName() const {return xmlSignalTag;}
  static const QString xmlSignalTag;

  Signal * signal() const;
protected:
  virtual void xml_writeProperties( XML_WRITEPROPERTIES_ARGS ) const;
  virtual void xml_writeBinaryData( XML_WRITEBINARYDATA_ARGS ) const;
  virtual bool xml_setBinaryData( XML_SETBINARYDATA_ARGS );
  virtual bool xml_setProperty( XML_SETPROPERTY_ARGS );
  virtual XMLMember xml_member( XML_MEMBER_ARGS );
private:
  Signal * _sig;
  // Used to load from XML stream
  SignalDB * _database;
  int _id;
};

} // namespace GeopsyCore

#endif // XMLSIGNAL_H
