/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2010-03-31
**  Authors :
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef XMLSUBSIGNALPOOL_H
#define XMLSUBSIGNALPOOL_H

#include <QGpCoreTools.h>

#include "SubSignalPool.h"
#include "XMLSignal.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT XMLSubSignalPool : public XMLClass
{
public:
  XMLSubSignalPool() {}
  XMLSubSignalPool(const SubSignalPool& subPool);
  virtual ~XMLSubSignalPool();

  virtual const QString& xml_tagName() const {return xmlSubSignalPoolTag;}
  static const QString xmlSubSignalPoolTag;

  SubSignalPool * subPool() const;
protected:
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
private:
  QList<XMLSignal *> _signals;
};

} // namespace GeopsyCore

#endif // XMLSUBSIGNALPOOL_H
