/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2003-12-22
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ArrayMap_H
#define ArrayMap_H

#include <QGpCoreTools.h>
#include <SciFigs.h>

#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT ArrayMap : public AxisWindow
{
public:
  ArrayMap( QWidget * parent = 0, AbstractNameLine * referenceLine = 0 );
  ~ArrayMap();

  NameLineLayer * mapLayer() const { return _mapLayer; }
  AbstractNameLine * line( int index ) { return _mapLayer->line( index ); }
  AbstractNameLine * addLine() { return _mapLayer->addLine(); }
  inline AbstractNameLine * addLine( const Pen& pen, const Symbol& sym );

  void setObjectName(QString name);

  void setLimitsArray();
  void setLimitsCoArray();

  int countPoints( double minR, double maxR );
  void optimizeRing( double& minR, double& maxR );
private:
  NameLineLayer * _mapLayer;
};

AbstractNameLine * ArrayMap::addLine( const Pen& pen, const Symbol& sym )
{
  return _mapLayer->addLine( pen, sym );
}

} // namespace GeopsyGui

#endif // ARRAYMAP_H
