/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2009-10-20
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALCOMPONENTSWIDGET_H
#define ASCIISIGNALCOMPONENTSWIDGET_H

#include <QWidget>
#include <GeopsyCore.h>
#include "ui_AsciiSignalComponentsWidget.h"

namespace GeopsyGui {

class AsciiSignalComponentsWidget : public QWidget, private Ui::AsciiSignalComponentsWidget
{
  Q_OBJECT
public:
  AsciiSignalComponentsWidget(QWidget * parent=0, Qt::WindowFlags f=0);
  ~AsciiSignalComponentsWidget();

  void setFormat(AsciiSignalFormat * f);
  void setReader(AsciiSignalFormatReader * r) {_reader=r;}
private slots:
  void on_addButton_clicked();
  void on_removeButton_clicked();
private:
  AsciiSignalFormatReader * _reader;
};

} // namespace GeopsyGui

#endif // ASCIISIGNALCOMPONENTSWIDGET_H
