/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2006-07-09
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CITYLOADER_H
#define CITYLOADER_H

#include <QGpGuiTools.h>
#include <GeopsyCore.h>

#include "ui_CityLoader.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT CityLoader : public Dialog, public Ui::CityLoader
{
  Q_OBJECT
public:
  CityLoader(QWidget * parent=0);
  ~CityLoader();
public slots:
  void scan();
  void on_closeBut_clicked();
  void on_loadBut_clicked();
  void on_mountBut_clicked();
  void on_unmountBut_clicked();
  void on_clearBut_clicked();
  void on_pathBrowse_clicked();
private slots:
  void resetSignalView();
private:
  CityScanner * _scanner;
  bool mountUnmount(const char * cmd);
  bool isAnySelected();
};

} // namespace GeopsyGui

#endif // CITYLOADER_H
